/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.storage.implementations;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.currency.CurrencyProvider;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.api.platform.players.PlatformPlayerService;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.storage.connection.configurate.ConfigurateLoader;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.economy.accounts.ImpactorAccount;
import net.impactdev.impactor.core.economy.storage.EconomyStorageImplementation;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.LoadingCache;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.BasicConfigurationNode;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.ConfigurationNode;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.serialize.SerializationException;
import net.kyori.adventure.key.Key;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class ConfigurateProvider
implements EconomyStorageImplementation {
    private final ConfigurateLoader loader;
    private final Path root;
    private final LoadingCache<Path, ReentrantLock> ioLocks;

    public ConfigurateProvider(@NotNull ConfigurateLoader loader) {
        this.loader = loader;
        this.root = Paths.get("config", new String[0]).resolve("impactor").resolve("economy");
        this.ioLocks = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(key -> new ReentrantLock());
    }

    @Override
    public String name() {
        return "Configurate - " + this.loader.name();
    }

    @Override
    public void init() throws Exception {
        Path accounts = this.root.resolve("accounts");
        this.createDirectoriesIfNotExists(Group.Users.transform(accounts));
        this.createDirectoriesIfNotExists(Group.Virtual.transform(accounts));
    }

    @Override
    public void shutdown() throws Exception {
    }

    @Override
    public void meta(PrettyPrinter printer) throws Exception {
        printer.add("File Counts:");
        long totalSize = 0L;
        printer.newline().add("Total Used Space: %d", totalSize);
    }

    private void createDirectoriesIfNotExists(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && (Files.isDirectory(path, new LinkOption[0]) || Files.isSymbolicLink(path))) {
            return;
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }

    @Override
    public boolean hasAccount(Currency currency, UUID uuid) throws Exception {
        for (Group group : Group.values()) {
            Path target = group.transform(this.root.resolve("accounts")).resolve(uuid.toString().substring(0, 2)).resolve(String.valueOf(uuid) + ".conf");
            if (!Files.exists(target, new LinkOption[0])) continue;
            ConfigurationNode node = this.read(target).node(currency.key().asString());
            return !node.virtual();
        }
        return false;
    }

    @Override
    public Account account(Currency currency, UUID uuid, Account.AccountModifier modifier) throws Exception {
        for (Group group : Group.values()) {
            Path target = group.transform(this.root.resolve("accounts")).resolve(uuid.toString().substring(0, 2)).resolve(String.valueOf(uuid) + ".conf");
            if (!Files.exists(target, new LinkOption[0])) continue;
            ConfigurationNode node = this.read(target).node(currency.key().asString());
            if (!node.virtual()) {
                return ImpactorAccount.load(currency, uuid, group == Group.Virtual, BigDecimal.valueOf(node.getDouble()));
            }
            ImpactorAccount.ImpactorAccountBuilder builder = new ImpactorAccount.ImpactorAccountBuilder();
            builder.currency(currency).owner(uuid);
            modifier.modify(builder);
            if (group == Group.Users) {
                builder.overrideVirtuality(false);
            }
            Account account = builder.build();
            this.save(account);
            return account;
        }
        Account.AccountBuilder builder = new ImpactorAccount.ImpactorAccountBuilder();
        builder.currency(currency).owner(uuid);
        builder = modifier.modify(builder);
        PlatformPlayerService service = Impactor.instance().services().provide(PlatformPlayerService.class);
        if (PlatformSource.SERVER_UUID.equals(uuid)) {
            builder.virtual();
        }
        Account account = (Account)builder.build();
        this.save(account);
        return account;
    }

    @Override
    public void save(Account account) throws Exception {
        Path accounts = this.root.resolve("accounts");
        Path target = (account.virtual() ? Group.Virtual.transform(accounts) : Group.Users.transform(accounts)).resolve(account.owner().toString().substring(0, 2)).resolve(String.valueOf(account.owner()) + ".conf");
        this.save(target, account);
    }

    @Override
    public void accounts(Multimap<Currency, Account> cache) throws Exception {
        Path root = this.root.resolve("accounts");
        EconomyService service = Impactor.instance().services().provide(EconomyService.class);
        CurrencyProvider currencies = service.currencies();
        try (Stream<Path> files = Files.walk(root, new FileVisitOption[0]);){
            files.filter(path -> path.getFileName().toString().endsWith(".conf")).forEach(path -> {
                try {
                    boolean virtual = path.getParent().getParent().getFileName().toString().equals("virtual");
                    String name = path.getFileName().toString();
                    UUID owner = UUID.fromString(name.substring(0, name.indexOf(".")));
                    ConfigurationNode data = this.read((Path)path);
                    for (Object key : data.childrenMap().keySet()) {
                        Collection registered;
                        Optional<Currency> currency = currencies.currency(Key.key((String)((String)key)));
                        if (!currency.isPresent() || !(registered = cache.get((Object)currency.get())).stream().noneMatch(account -> account.owner().equals(owner))) continue;
                        ImpactorAccount account2 = ImpactorAccount.load(currency.get(), owner, virtual, BigDecimal.valueOf(data.node(key).getDouble()));
                        cache.put((Object)account2.currency(), (Object)account2);
                    }
                }
                catch (Exception e) {
                    BaseImpactorPlugin.instance().logger().severe("Economy: Failed to read account file: " + String.valueOf(path.getFileName()));
                    e.printStackTrace();
                }
            });
        }
    }

    @Override
    public void delete(Currency currency, UUID uuid) throws Exception {
        for (Group group : Group.values()) {
            Path target = group.transform(this.root.resolve("accounts")).resolve(uuid.toString().substring(0, 2)).resolve(String.valueOf(uuid) + ".conf");
            if (!Files.exists(target, new LinkOption[0])) continue;
            ConfigurationNode root = this.read(target);
            ConfigurationNode data = root.node(currency.key().asString());
            if (!data.virtual()) {
                if (!root.removeChild(data.key())) {
                    throw new IllegalStateException("Failed to delete account...");
                }
                this.loader.loader(target).save(root);
            }
            if (root.empty()) {
                Files.delete(target);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logTransaction(EconomyTransaction transaction) throws Exception {
        Account target = transaction.account();
        Path accounts = this.root.resolve("accounts");
        Path transactions = (target.virtual() ? Group.Virtual.transform(accounts) : Group.Users.transform(accounts)).resolve(target.owner().toString().substring(0, 2)).resolve("transactions");
        DateTimeFormatter date = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault());
        Path branch = transactions.resolve(date.format(transaction.timestamp()));
        Path leaf = branch.resolve("transactions.log");
        this.createDirectoriesIfNotExists(leaf.getParent());
        ReentrantLock lock = Objects.requireNonNull(this.ioLocks.get(leaf));
        lock.lock();
        try {
            ConfigurationNode node = Files.exists(leaf, new LinkOption[0]) ? this.loader.loader(leaf).load() : BasicConfigurationNode.root();
            int id = node.node("transactions").getInt(0) + 1;
            node.node("transactions").set(id);
            node.node("" + id).node("currency").set(transaction.currency().key().asString());
            node.node("" + id).node("type").set(transaction.type().name());
            node.node("" + id).node("result").set(transaction.result().name());
            node.node("" + id).node("amount").set(transaction.amount().doubleValue());
            node.node("" + id).node("timestamp").set(transaction.timestamp());
            this.loader.loader(leaf).save(node);
        }
        catch (Exception e) {
            ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void sync(Account account, Instant since) throws Exception {
        Path accounts = this.root.resolve("accounts");
        Path transactions = (account.virtual() ? Group.Virtual.transform(accounts) : Group.Users.transform(accounts)).resolve(account.owner().toString().substring(0, 2)).resolve("transactions");
        DateTimeFormatter date = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault());
        Files.walk(transactions, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
            System.out.println("Reading path: " + String.valueOf(path));
            String name = path.getParent().getFileName().toString();
            LocalDate timestamp = LocalDate.parse(name, date);
            LocalDate compare = LocalDate.ofInstant(since, ZoneId.systemDefault());
            return compare.isBefore(timestamp) || compare.isEqual(timestamp);
        }).map(path -> {
            ReentrantLock lock = Objects.requireNonNull(this.ioLocks.get((Path)path));
            lock.lock();
            try {
                ConfigurationNode configurationNode = this.loader.loader((Path)path).load();
                return configurationNode;
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                ConfigurationNode configurationNode = null;
                return configurationNode;
            }
            finally {
                lock.unlock();
            }
        }).filter(Objects::nonNull).map(node -> {
            NodeCollection collection = new NodeCollection();
            int count = node.node("transactions").getInt(0);
            for (int i = 0; i < count; ++i) {
                try {
                    ConfigurationNode target = node.node("" + (i + 1));
                    Instant timestamp = target.node("timestamp").get(Instant.class);
                    Currency currency = EconomyService.instance().currencies().currency(Key.key((String)target.node("currency").getString())).orElse(null);
                    Preconditions.checkNotNull((Object)timestamp);
                    if (!since.isBefore(timestamp) || currency == null || !account.currency().equals(currency)) continue;
                    collection.append(target);
                    continue;
                }
                catch (SerializationException e) {
                    throw new RuntimeException(e);
                }
            }
            return collection;
        }).flatMap(collection -> collection.valid.stream()).map(node -> {
            try {
                return new LoggedTransaction(EconomyService.instance().currencies().currency(Key.key((String)node.node("currency").getString())).orElse(null), BigDecimal.valueOf(node.node("amount").getDouble(0.0)), EconomyTransactionType.valueOf(node.node("type").getString()), EconomyResultType.valueOf(node.node("result").getString()), node.node("timestamp").get(Instant.class));
            }
            catch (SerializationException e) {
                throw new RuntimeException(e);
            }
        }).sorted((a, b) -> b.timestamp.compareTo(a.timestamp)).forEach(System.out::println);
    }

    @Override
    public boolean purge() throws Exception {
        FileUtils.cleanDirectory((File)this.root.toFile());
        return true;
    }

    private long size(Stream<Path> paths) throws IOException {
        return paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(this::sizeCatching).sum();
    }

    private long sizeCatching(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ConfigurationNode read(Path target) throws IOException {
        ReentrantLock lock = Objects.requireNonNull(this.ioLocks.get(target));
        lock.lock();
        try {
            if (!target.toFile().exists()) {
                throw new FileNotFoundException("Target file was not found");
            }
            ConfigurationNode configurationNode = this.loader.loader(target).load();
            return configurationNode;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Path target, @NotNull Account account) throws IOException {
        this.createDirectoriesIfNotExists(target.getParent());
        ReentrantLock lock = Objects.requireNonNull(this.ioLocks.get(target));
        lock.lock();
        try {
            ConfigurationNode node = Files.exists(target, new LinkOption[0]) ? this.loader.loader(target).load() : BasicConfigurationNode.root();
            node.node(account.currency().key().asString()).set(account.balance().doubleValue());
            this.loader.loader(target).save(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    private static enum Group {
        Users("users"),
        Virtual("virtual");

        private final String directory;

        private Group(String directory) {
            this.directory = directory;
        }

        private Path transform(Path parent) {
            return parent.resolve(this.directory);
        }
    }

    private record LoggedTransaction(Currency currency, BigDecimal amount, EconomyTransactionType type, EconomyResultType result, Instant timestamp) {
    }

    private static final class NodeCollection {
        public final List<ConfigurationNode> valid = Lists.newArrayList();

        private NodeCollection() {
        }

        public void append(ConfigurationNode node) {
            this.valid.add(node);
        }
    }
}

